/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.item.ore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import novamachina.exnihilosequentia.common.item.OreItem;
import novamachina.exnihilosequentia.common.network.HandshakeMessages;
import novamachina.exnihilosequentia.common.utility.Color;
import org.jetbrains.annotations.NotNull;

public class Ore {
    private static Map<String, Boolean> enabledMap = new HashMap<String, Boolean>();
    private static Map<String, Boolean> oreMap = new HashMap<String, Boolean>();
    @Nonnull
    private final String name;
    @Nullable
    private final RegistryObject<OreItem> pieceItem;
    private final Color color;
    @Nullable
    private RegistryObject<OreItem> rawOreItem;
    @Nullable
    private RegistryObject<Item> ingotItem;

    public Ore(@Nonnull String name, boolean enabled, boolean generateRaw, boolean generateIngot, Color color, DeferredRegister<Item> registry) {
        this.name = name;
        this.color = color;
        oreMap.put(name, generateIngot);
        enabledMap.put(name, enabled);
        if (generateRaw) {
            this.rawOreItem = registry.register(this.getRawOreName(), () -> new OreItem(this));
        }
        this.pieceItem = registry.register(this.getPieceName(), () -> new OreItem(this));
        if (generateIngot) {
            this.ingotItem = registry.register(this.getIngotName(), () -> new OreItem(this));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean updateEnabledOres(@Nonnull HandshakeMessages.S2COreList message) {
        List<String> oreList = message.getOreList();
        enabledMap.replaceAll((k, v) -> false);
        if (oreList != null) {
            for (String ore : oreList) {
                enabledMap.put(ore, true);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public static List<String> getEnabledOres() {
        ArrayList<String> enabledOres = new ArrayList<String>();
        for (String key : enabledMap.keySet()) {
            if (!Boolean.TRUE.equals(enabledMap.get(key))) continue;
            enabledOres.add(key);
        }
        return enabledOres;
    }

    public static Map<String, Boolean> getOreMap() {
        return oreMap;
    }

    public Color getColor() {
        return this.color;
    }

    @Nullable
    public Item getIngotItem() {
        if (this.ingotItem == null) {
            return null;
        }
        return (Item)this.ingotItem.get();
    }

    public String getIngotName() {
        return this.name + "_ingot";
    }

    @Nonnull
    public String getOreName() {
        return this.name;
    }

    @Nullable
    public OreItem getPieceItem() {
        return (OreItem)((Object)this.pieceItem.get());
    }

    public String getPieceName() {
        return this.name + "_pieces";
    }

    @Nullable
    public OreItem getRawOreItem() {
        if (this.rawOreItem != null) {
            return (OreItem)((Object)this.rawOreItem.get());
        }
        return null;
    }

    public String getRawOreName() {
        return "raw_" + this.name;
    }

    public boolean isEnabled() {
        return enabledMap.getOrDefault(this.name, false);
    }

    public void setEnabled(boolean enabled) {
        enabledMap.put(this.name, enabled);
    }
}

